/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class RowSetDynaClass
implements DynaClass,
Serializable {
    protected boolean lowerCase = true;
    protected DynaProperty[] properties = null;
    protected Map propertiesMap = new HashMap();
    protected List rows = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;

    public String getName() {
        return this.getClass().getName();
    }

    public RowSetDynaClass(ResultSet resultSet) throws SQLException {
        this(resultSet, true);
    }

    protected void copy(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            BasicDynaBean bean = new BasicDynaBean(this);
            int i = 0;
            while (i < this.properties.length) {
                String name = this.properties[i].getName();
                bean.set(name, resultSet.getObject(name));
                ++i;
            }
            this.rows.add(bean);
        }
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        ArrayList<DynaProperty> list = new ArrayList<DynaProperty>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int n = metadata.getColumnCount();
        int i = 1;
        while (i <= n) {
            DynaProperty dynaProperty = this.createDynaProperty(metadata, i);
            if (dynaProperty != null) {
                list.add(dynaProperty);
            }
            ++i;
        }
        this.properties = list.toArray(new DynaProperty[list.size()]);
        int i2 = 0;
        while (i2 < this.properties.length) {
            this.propertiesMap.put(this.properties[i2].getName(), this.properties[i2]);
            ++i2;
        }
    }

    public RowSetDynaClass(ResultSet resultSet, boolean lowerCase) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        this.lowerCase = lowerCase;
        this.introspect(resultSet);
        this.copy(resultSet);
    }

    public List getRows() {
        return this.rows;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected Class loadClass(String className) throws SQLException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return cl.loadClass(className);
        }
        catch (Exception e) {
            throw new SQLException("Cannot load column class '" + className + "': " + e);
        }
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
        Class clazz;
        String name = null;
        name = this.lowerCase ? metadata.getColumnName(i).toLowerCase() : metadata.getColumnName(i);
        String className = null;
        try {
            className = metadata.getColumnClassName(i);
        }
        catch (SQLException e) {
            // empty catch block
        }
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = RowSetDynaClass.class$("java.lang.Object")) : class$java$lang$Object;
        if (className != null) {
            clazz = this.loadClass(className);
        }
        return new DynaProperty(name, clazz);
    }
}

